<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="/WEB-INF/displaytag-12.tld" prefix="display" %>
<%@ taglib uri="http://beehive.apache.org/netui/tags-html-1.0" prefix="netui" %>

<%@ include file="printerFriendlyOpen.jspf"%>

<netui:form action="returnToViewAction">
<h2>
<netui:content value="${pageFlow.currentLab.specimen}"/> Specimen<br/>
Collected on <netui:content value="${pageFlow.currentLab.collectedOn}"/> 
at <netui:content value="${pageFlow.currentLab.orderingLocation}"/> 
</h2>

<p>
Test results slightly outside the reference range are not unusual.
Your provider has reviewed your test results and 
will contact you for any important issues.  
If you have further questions, 
please do not hesitate to contact your primary care provider. If you
have an amended test and you want to see the history, go to the <b>Comments</b>
on the <b>Details</b> page.
<br/><br/>
<b>Results Key: * = Critical</b>
<br/><br/>
<p>

<display:table id="${pageFlow.tableUID}.currentTests" 
        uid="${pageFlow.tableUID}.currentTests" 
	    name="${pageFlow.currentTests}"
        pagesize="<%=java.lang.Integer.MAX_VALUE%>" 
        sort="list"  
        defaultsort="2" 
        defaultorder="ascending"
        decorator="gov.va.med.mhv.phr.chemlabs.decorator.ChemLabsTestTableDecorator">
    <display:setProperty name="paging.banner.placement" value="" />
    
	<display:column property="statusCheck" title=""/>      
	<display:column property="labTestName" title="Test Name"/>
	<display:column property="result" title="Result"/>
	<display:column property="units" title="Units"/>
	<display:column property="referenceRange" title="Reference Range"/>
	<display:column property="details" title="Test Details"/>
</display:table>
</netui:form>

<%@ include file="chemLabsDisclaimer.jspf" %>
<br>

<%@ include file="../../common/printerFriendlyClose.jspf"%>
